<?php

namespace App\Models\ManagerDashboard\Settings;

use App\Models\AdminDashboard\Finances\SubscriptionDetailsRetrieval;
use App\Models\AdminDashboard\Products\Product;
use App\Models\AdminDashboard\School\School;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    use HasFactory;

    protected $table = 'subscriptions';

    protected $guarded = [];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function transactionData()
    {
        return $this->hasOne(TransactionBankdata::class);
    }

    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function transactionPaymentGatewayData()
    {
        return $this->hasOne(TransactionPaymentGatewayData::class);
    }
    public function subscriptionDetailsRetrieval()
    {
        return $this->hasOne(SubscriptionDetailsRetrieval::class);
    }
}
