<?php

namespace App\Models\ManagerDashboard\Reports\StudentAdmisnstrativeReport;

use App\Models\Week;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\AdminDashboard\School\SchoolSemester;
use Illuminate\Database\Eloquent\SoftDeletes;

class StudentAdminstrativeAbsentLate extends Model
{
    use SoftDeletes;
    
    protected $table = 'report_student_adminstrative_absent_lates';

    protected $guarded = [];

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function semester(){
        return $this->belongsTo(SchoolSemester::class);
    }

    public function week(){
        return $this->belongsTo(Week::class);
    }

}

