<?php

namespace App\Models\ManagerDashboard\Namazeg\Violations;

use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NamazegRedirectGuidance extends Model
{
    //نموذج إحالة لإدارة قسم التوجيه الطلاب
    use HasFactory, SoftDeletes;
    protected $guarded = [];
    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }
    public function student()
    {
        return $this->belongsTo(Student::class, 'student_id');
    }
    public function VStudentPunishment()
    {
        return $this->belongsTo(ViolationStudentPunishment::class, 'v_student_punishment_id')->with('VStudentTitle');
    }

    public function setActionsAttribute($value)
    {
        $this->attributes['actions'] = json_encode($value);
    }
    public function getActionsAttribute($value)
    {
        return $this->attributes['actions'] = json_decode($value);
    }

    

}
