<?php

namespace App\Models\ManagerDashboard\Namazeg;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NamazegMaintenanceForm extends Model
{
    //  162 طلب صيانة
    use HasFactory, SoftDeletes;
    protected $casts = [
        "maintenance_desc"=>"array"
    ];

    protected $guarded=[];
    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    
    public function setMaintenanceTypeAttribute($value)
    {
        $this->attributes['maintenance_type'] = json_encode($value, JSON_UNESCAPED_UNICODE);

    }
    public function getMaintenanceTypeAttribute($value)
    {
        return json_decode($value, true);
    }



}
