<?php

namespace App\Models\ManagerDashboard\Namazeg;

use App\Models\AdminDashboard\School\SchoolEmployee;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NamazegFinalReportClassActivity extends Model
{
    //   التقرير الختامي لحصص الاتقان للعام الدراسي 188
    use HasFactory, SoftDeletes;
    protected $guarded = [];
    protected $casts = [
        'employee_ids' => 'array'
    ];

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }


    public function getEmployeesAttribute()
    {
        // Use the array directly
        $employeeIdsArray = $this->employee_ids;

        // Ensure it's a valid array and not empty
        if (is_array($employeeIdsArray) && !empty($employeeIdsArray)) {
            return SchoolEmployee::whereIn('id', $employeeIdsArray)->get();
        }

        return collect();  // Return an empty collection if there are no valid employee IDs
    }
}
