<?php

namespace App\Models\ManagerDashboard\Namazeg;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\Specialization;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NamazegClassPlanActivity extends Model
{
    // الخطة العامة لأنشطة حصص الاتقان للعام الدراسي 186
    use HasFactory, SoftDeletes;
    protected $guarded = [];

    protected $casts = [
        'emplyee_ids' => 'array',
        'specializations_ids' => 'array',
    ];

    public function getEmployeesAttribute()
    {
        // Use the array directly
        $employeeIdsArray = $this->emplyee_ids;

        // Ensure it's a valid array and not empty
        if (is_array($employeeIdsArray) && !empty($employeeIdsArray)) {
            return SchoolEmployee::whereIn('id', $employeeIdsArray)->get();
        }

        return collect();  // Return an empty collection if there are no valid employee IDs
    }
    public function getSpecializationsAttribute()
    {
        // Use the array directly
        $specializations_idsArray = $this->specializations_ids;

        // Ensure it's a valid array and not empty
        if (is_array($specializations_idsArray) && !empty($specializations_idsArray)) {
            return Specialization::whereIn('id', $specializations_idsArray)->get();
        }

        return collect();  // Return an empty collection if there are no valid employee IDs
    }

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }
}
