<?php

namespace App\Models\ManagerDashboard\Namazeg;

use App\Models\AdminDashboard\School\SchoolEmployee;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NamazegAbsenceQuestioning extends Model
{
    // مساءلة الغياب169  
    use HasFactory, SoftDeletes;
    protected $guarded=[];
    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }
    public function employee()
    {
        return $this->belongsTo(SchoolEmployee::class, 'employee_id')->with('currentWork');
    }

    public function getStatusAttribute(){
        $action = $this->action;
        return $action?'مكتمل': 'غير مكتملة';
    }

    public function action(){
        return $this->hasOne(AbsenceQuestioningAction::class, 'absence_questioning_id')->with('action');
    }
}
