<?php

namespace App\Models\ManagerDashboard\Exams\SupervisionCommittees;

use App\Models\AdminDashboard\School\Subject;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CorrectionAssignment extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'exams_correction_committee_assignments';

    protected $guarded = [];

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function members()
    {
        return $this->hasMany(CorrectionAssignmentMember::class,'assignment_id');
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);    
    }
}
