<?php

namespace App\Models\ManagerDashboard\Exams\StudentCommittees;

use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\Student;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudentSeatingNumber extends Model
{
    use HasFactory;

    protected $table = 'exams_student_committee_seating_numbers';

    protected $guarded = [];

    public function student()
    {
        return $this->belongsTo(Student::class, 'student_id');
    }

    public function committee()
    {
        return $this->belongsTo(StudentCommittee::class, 'committee_id');
    }

    public function committeeData()
    {
        return $this->hasOne(StudentCommitteeData::class, 'committee_id', 'committee_id');
    }

    public function semester()
    {
        return $this->belongsTo(SchoolSemester::class, 'semester_id');
    }
}
