<?php

namespace App\Models\ManagerDashboard\Exams\NamazegPlans;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\Subject;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TeacherQuestionAssignment extends Model
{
    use HasFactory,SoftDeletes;
    
    protected $table = 'exams_namazeg_teacher_question_assignments';

    protected $guarded = [];
    
    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }
    public function employee()
    {
        return $this->belongsTo(SchoolEmployee::class, 'teacher_id');
    }

    public function teacherSubjects()
    {
        return $this->hasMany(TeacherQuestionAssignmentSubject::class, 'tqa_assignment_id');
    }
}
