<?php

namespace App\Models\ManagerDashboard\Exams\NamazegPlans\TeacherDeclaration;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TeacherCurriculumDeclaration extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'exams_namazeg_teacher_curriculum_declarations';
    
    protected $guarded = [];
    
    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function employee()
    {
        return $this->belongsTo(SchoolEmployee::class, 'teacher_id');
    }
}
