<?php

namespace App\Models\ManagerDashboard\Exams\NamazegPlans\MonitorDistributions;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Exams\NamazegPlans\DailyObservers\DailyObserves;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DistribtionAssignmentMonitor extends Model
{
    use HasFactory;

    protected $table = 'exams_namazeg_distribution_assignment_monitors';
    
    protected $guarded = [];

    public function employee()
    {
        return $this->belongsTo(SchoolEmployee::class, 'employee_id');
    }
    public function dailyObserve()
    {
        return $this->hasOne(DailyObserves::class, 'monitor_id');
    }

    public function schoolId()
    {
        return $this->dailyObserve->school_id;
    }
}
