<?php

namespace App\Models\ManagerDashboard\Assignments;

use App\Models\AdminDashboard\School\CurrentWork;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Assignment extends Model
{
    use HasFactory; use SoftDeletes;
    protected $table = 'assignments';

    protected $guarded=[];

    public function assignmentEmployees()
    {
        return $this->hasMany(AssignmentEmployee::class, 'assignment_id');
    }

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function job()
    {
        return $this->belongsTo(CurrentWork::class, 'current_work_id');
    }

}
