<?php

namespace App\Models\ManagerDashboard\AbsenseAndLateness;

use App\Models\AdminDashboard\Procedures\LateProcedure\LateProcedure;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class StudentLatenessProcedureSubItem extends Model
{
    use SoftDeletes,HasFactory;

    protected $table='std_lateness_procedures_sub_items';
    protected $guarded=[];
    protected $appends = ['serial_number','namozeg_name'];

    public function mainItem(){
        return $this->belongsTo(StudentLatenessProcedureMainItem::class,'main_item_id');
    }

    public function procedure(){
        return $this->belongsTo(LateProcedure::class,'procedure_id');
    }

    public function namozegVersion(){
        return $this->belongsTo(NamazegVersion::class,'namozeg_version_id');
    }

    public function getSerialNumberAttribute()
    {
        return $this->namozegVersion()->first()->serial_number;
    }
    
    public function getNamozegNameAttribute()
    {
        return $this->namozegVersion()->first()->namozeg()->first()->name;
    }

    protected $hidden = ['created_at','updated_at','deleted_at'];
}
