<?php

namespace App\Models\ManagerDashboard\AbsenseAndLateness;

use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\Student;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class StudentAttendance extends Model
{
    use SoftDeletes,HasFactory;

    protected $table='students_attendance';
    protected $guarded=[];

    public function student(){
        return $this->belongsTo(Student::class,'student_id');
    }

    public function semester(){
        return $this->belongsTo(SchoolSemester::class,'semester_id');
    }

    public function class(){
        return $this->belongsTo(SchoolClass::class,'class_id');
    }
    
}
