<?php

namespace App\Models\ManagerDashboard\AbsenseAndLateness;

use App\Models\AdminDashboard\School\Period;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\Student;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class PeriodStudentAttendance extends Model
{
    use SoftDeletes,HasFactory;

    protected $table='period_students_attendance';
    protected $guarded=[];

    public function student(){
        return $this->belongsTo(Student::class,'student_id');
    }

    public function semester(){
        return $this->belongsTo(SchoolSemester::class,'semester_id');
    }

    public function period(){
        return $this->belongsTo(Period::class,'period_id');
    }
    
}
