<?php

namespace App\Models;

use App\Traits\CascadeSoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GuideRegulation extends Model
{
    use SoftDeletes,CascadeSoftDeletes;

    protected $table='guides_and_regulations';
    protected $cascadeDeletes = ['files'];

    public function files()
    {
        return $this->hasMany(GuideRegulationFile::class, 'guide_regulation_id');
    }
}
