<?php

namespace App\Models;

use App\Models\ManagerDashboard\Tasks\Task;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class Event extends Model 
{
    use SoftDeletes,HasFactory;

    protected static $logAttributes = ['name', 'date', 'location'];
    protected static $logDescription = 'An event was created/updated/deleted';

    protected $table='events';
    protected $guarded=[];

    public function getDurationAttribute(){
        $dateFrom = Carbon::createFromFormat('d/m/Y', $this->date_from);
        $dateTo = Carbon::createFromFormat('d/m/Y', $this->date_to);
        return $dateFrom->diffInDays($dateTo)+1;
    }

    public function task(){
        return $this->hasMany(Task::class,'event_id');
    }


}
