<?php

namespace App\Models\AdminDashboard\School;

use App\Models\ManagerDashboard\Messages\MessageReciver ;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class SchoolEmployee extends Model
{
    use SoftDeletes,HasFactory;

    protected $table='school_employees';
    protected $guarded=[];
                    
    public function specialization(){
        return $this->belongsTo(Specialization::class,'specialization_id');
    }

    public function currentWork(){
        return $this->belongsTo(CurrentWork::class,'current_work_id');
    }

    public function my_notification()
    {
        return $this->hasOne(MessageReciver::class,'user_id','id')
            ->orderBy('updated_at', 'Desc')
            ->with('message');
    }
    public function my_notifications()
    {
        return $this->hasMany(MessageReciver::class,'user_id','id')
            ->with('message');
    }

    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }

    public function subjects()
    {
        return $this->hasMany(Subject::class, 'id');
    }
}
