<?php

namespace App\Models\AdminDashboard\School;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\AdminDashboard\School\SchoolGrade;
use App\Models\AdminDashboard\EducationalDepartment\EducationalDepartment;
use App\Models\AdminDashboard\EducationalOffice\EducationalOffice;
use App\Models\AdminDashboard\AreaAndCities\Area;
use App\Models\AdminDashboard\AreaAndCities\City;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAttendance;
use App\Models\ManagerDashboard\Settings\BusinessAccountData;
use App\Models\ManagerDashboard\NotificationSettings\NotificationSchoolSetting;

class School extends Model
{
    use HasFactory; use SoftDeletes;

    protected $table= 'schools';
    protected $guarded= [];

    public function schoolGrade(){
        return $this->belongsTo(SchoolGrade::class);
    }

    public function educationDepartment(){
        return $this->belongsTo(EducationalDepartment::class);
    }

    public function educationalOffice(){
        return $this->belongsTo(EducationalOffice::class);
    }

    public function area(){
        return $this->belongsTo(Area::class);
    }

    public function city(){
        return $this->belongsTo(City::class);
    }
    public function refrence(){
        return $this->hasOne(SchoolReference::class);
    }

    public function classes(){
        return $this->hasMany(SchoolClass::class);
    }
    public function employees(){
        return $this->hasMany(SchoolEmployee::class);
    }
    public function students(){
        return $this->hasMany(Student::class);
    }
    public function students_attendance(){
        return $this->hasMany(StudentAttendance::class);
    }
    public function teachers_attendance(){
        return $this->hasMany(SchoolEmployeeAttendance::class)->where('type','teacher');
    }

   
    public function notification_settings(){
        return $this->hasMany(NotificationSchoolSetting::class);
    }

}
