<?php

namespace App\Models\AdminDashboard\Coupons;

use App\Models\AdminDashboard\Products\Product;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Coupon extends Model
{
    use HasFactory; use SoftDeletes;

    protected $table = 'coupons';

    protected $guarded = [];

    public function products()
    {
        return $this->belongsToMany(Product::class,'coupon_product','coupon_id','product_id')->withTimestamps();
    }
}
