<?php

namespace App\Http\Resources\Violation;
use Illuminate\Http\Resources\Json\JsonResource;
class ViolationTitleStepResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'violation_title_id'=>$this->violation_name?->id,
            'violation_name'=>$this->violation_name?->name,
            'punishments'=>$this->punishments?->map(function($punishment){
                return $punishment;
            }),
        ];
    }
}
