<?php

namespace App\Http\Resources\Violation;
use App\Models\Violation;
use App\Models\GradeViolation;
use App\Models\Namazeg;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;
use App\Http\Resources\Violation\ViolationTitleUpdateRequest;

use App\Http\Resources\Violation\ViolationTypeResource;


class ViolationTitleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'name'=>$this->violation_name->name,
            'name_id'=>$this->name,
            'has_related'=>$this->has_related,
            'punishment_ids'=>$this->punishments->pluck('violation_punishment_id'),
            'punishment_options'=> NamazegResource::collection(Namazeg::where('type','violations')->get()),
            'violation_grade_id'=>$this->violation_grade_id,
        ];
    }
}
