<?php

namespace App\Http\Resources\Violation;
use App\Models\Violation;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;
class ViolationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'violation_category_id'=>$this->id,
            'name'=>$this->name,
            'school_grade'=>$this->grade->name,
            'school_grade_id'=>$this->school_grade_id,
            'violation_grades'=> $this->violation_grades?GradeViolationResource::collection($this->violation_grades):''
        ];
    }
}
