<?php

namespace App\Http\Resources\User;
use Spatie\Permission\Models\Permission;
use Illuminate\Http\Resources\Json\JsonResource;
class PermissionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');

        return [
            'id'=>$this->id,
            'name' =>$this->name,
            'name_ar' =>$this->name_ar,
            'sub_permissions'=>$this->getSubPermissions($this->id)
        ];
    }

    private function getSubPermissions($parent_id){
        $permissions = Permission::where('parent_id', $parent_id)->get();
        if ($permissions->isEmpty()) {
            return [];
        }

        return $permissions->map(function ($permission) {
            $data = [
                'id' => $permission->id,
                'name' => $permission->name,
                'name_ar' => $permission->name_ar,
            ];

            $subPermissions = $this->getSubPermissions($permission->id);
            if (!empty($subPermissions)) {
                $data['sub_permissions'] = $subPermissions;
            }
            return $data;
        })->all();
    }
}
