<?php

namespace App\Http\Resources\School;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Helpers\Helper;
use Carbon\Carbon;


class SchoolEmployeeAttendanceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        if ($this->date) {
            $date = $this->date;
            if ($request['date_type'] == "hijri") {
                $date = Helper::getCoptic($this->date);
            }
        }

        $date = Carbon::createFromFormat('d/m/Y', $this->date);
        //$day = $date->translatedFormat('l');

        return [
            'id'=> $this->id,
            'name'=> $this->schoolEmployee?->name,
            'school_employee_id'=>$this->school_employee_id,
            'date'=>Carbon::parse($date)->translatedFormat('d/m/Y  l'),
            'date_type'=>$this->date_type,
            'status'=> $this->status,
            'absence_reason'=> trans("api.$this->absence_reason"),
            'other_absence_reason'=> $this->other_absence_reason,
            'late_reason'=> $this->late_reason,
            'late_from_time'=> $this->late_from_time,
            'late_to_time'=> $this->late_to_time,

            'is_attended'=>($this->status == 'attended')?1:0,
            'is_absent'=> ($this->status == 'absent')?1:0,
            'is_late'=> ($this->status == 'late')?1:0,
        ];
    }
}
