<?php

namespace App\Http\Resources\School;

use App\Helpers\Helper;
use Illuminate\Http\Resources\Json\JsonResource;

class GuideRegulationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        return [
            'id'=>$this->id,
            'name' =>$this->name,
            'status'=>($this->status == 1)?trans('api.active'):trans('api.inactive'),
            'icon' => $this->icon ? Helper::uploadedFilesPath('guidesRegulations',$this->icon) : null,
            'files'=>$this->files,
        ];
    }
}