<?php

namespace App\Http\Resources\ManagerDashboard\WaitingPeriodsSchedule;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\WaitingPeriodsSchedule\WaitingPeriodsScheduleDataResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class WaitingPeriodsScheduleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'school_employee_id'=>$this->school_employee_id,
            'employee'=>$this->absent_employee?->name,
            'day_id'=>$this->day_id,
            'day'=>$this->day_name->name,
            'semester_id'=>$this->semester_id,
            'serial_number'=>$this->serial_number,
            'namazeg_version_id'=>$this->namazeg_version_id,
            'creation_date' => $this->creation_date,
            'creation_date_options'=> Helper::getDateOptions($this->creation_date, 'coptic'),
            // 'absent_periods_count'=> $this->absent_periods_count,
            'registerd_periods_count'=> count($this->schedule_data),
            'waitinig_periods_schedule' => WaitingPeriodsScheduleDataResource::collection($this->schedule_data)  
        ];
    }
}
