<?php

namespace App\Http\Resources\ManagerDashboard\ViolationStudents;

use App\Helpers\Helper;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class ViolationStudentsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */

    public function toArray($request)
    {
        return [
            'student_id' => $this->student_id,
            'student_name' => $this->student?->name,
            'ssn' => $this->student?->ssn,
            'class_name' => $this->student?->schoolClass->className->name,
            'class_number' => $this->student?->schoolClass->class_number,
            'n_violations' => $this->n_violations,
            'pending_violations' => $this->pending_violations($this->student_id) > 0,
            'latest_created_at' => $this->latest_created_at ? Carbon::parse($this->latest_created_at)->format('d/m/Y') : null,
        ];
    }
}
