<?php

namespace App\Http\Resources\ManagerDashboard\ViolationStudents;

use App\Models\Violation;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;
use App\Http\Resources\Violation\ViolationResource;
use App\Models\ManagerDashboard\Violations\ViolationStudentTitle;

class GradeViolationStudentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $violation_title_ids = $this->student_violations->pluck('id')->toArray();
        $n_grade_count = ViolationStudentTitle::where('violation_student_id', $violation_title_ids)
            ->where('created_at', '<=', Carbon::now()->subDays(7))
            ->where('status', 'started')->count();

        return [
            'violation_grade_id' => $this->id,
            'name' => $this->name,
            'n_grade_count' => $n_grade_count,
            'violations' => NamazegviolationStudentResource::collection($this->student_violations)
        ];
    }
}
