<?php

namespace App\Http\Resources\ManagerDashboard\Tables\ShiftSchedule;

use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftSchedule;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use JWTAuth;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftTeacher;


class ShiftScheduleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School:: where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $ShiftScheduleTeachers = ShiftScheduleTeacherResource::collection(ShiftTeacher::where('school_id',$school->id)->where('shift_schedule_id',$this->id)->get());
        $checkIfCreated =  ShiftTeacher::where('school_id',$school->id)->where('school_employee_id','!=',NULL)->where('shift_schedule_id',$this->id)->first();

        return [
            'title'=>'جدول المناوبة الاسبوعي',
            'semester_name'=>$this->semester?->name,
            'week'=>$this->week?->name,
            'serial_number'=>$this->namozegVersion->serial_number,
            'namazeg_version_id'=>$this->namazeg_version_id,
            'created_ststus'=>($checkIfCreated)? 'yes' :'no',
            'ShiftScheduleTeachers'=>$ShiftScheduleTeachers,
        ];
    }
}
