<?php

namespace App\Http\Resources\ManagerDashboard\Tables\ShiftSchedule;

use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftSchedule;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SemesterShiftResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $shiftScheduleWeeks = ShiftScheduleWeekResource::collection(ShiftSchedule::where('semester_id',$this->id)->get());
        return [
            'semester_name'=>$this->name,
            'semester_id'=>$this->id,
            'shiftScheduleWeeks'=>$shiftScheduleWeeks,
        ];
    }
}
