<?php

namespace App\Http\Resources\ManagerDashboard\Tables\ClassRoomVisits;

use App\Helpers\Helper;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\ResourceCollection;

class ClassroomVisitCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @return array<int|string, mixed>
     */
    public function toArray($request): array
    {
        return [
            'data' => $this->collection->map(function ($semester) {
                // Get the first visit for the semester to extract the semester_namozeg_serial_number
                $firstVisit = $semester->classVisits->first();
                $semester_namozeg_serial_number = $firstVisit->semesterNamozegVersion?->serial_number ?? null;

                return [
                    'semester_id' => $semester->id,
                    'semester_name' => $semester->name,
                    'semester_namozeg_serial_number' => $semester_namozeg_serial_number, // Return the semester-level serial number

                    'class_visits' => $semester->classVisits->map(function ($visit) {
                        return [
                            'id' => $visit->id,
                            'namozeg_serial_number' => $visit->namozegVersion?->serial_number,
                            'visiting_teacher_id' => $visit->visitingTeacher?->id,
                            'visiting_teacher' => $visit->visitingTeacher?->name,
                            'visited_teacher_id' => $visit->visitedTeacher?->id,
                            'visited_teacher' => $visit->visitedTeacher?->name,
                            'period_id' => $visit->period->id,
                            'period' => $visit->period->name,
                            'subject_id' => $visit->subject->id,
                            'subject' => $visit->subject->name,
                            'school_class_id' => $visit->class?->id,
                            'class_id' => $visit->class?->className?->id,
                            'class_name' => $visit->class?->className?->name,
                            'classNumber' => $visit->class?->class_number,
                            'date_options' => Helper::getDateOptions($visit->date, $visit->date_type),
                           
                        ];
                    }),
                ];
            }),
        ];
    }
}
