<?php

namespace App\Http\Resources\ManagerDashboard\Reports\StudentAdminstrativeReport;
use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolEmployeeAttendance;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAttendance;
use App\Models\ManagerDashboard\AbsenseAndLateness\PeriodStudentAttendance;
use DateTime;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLateness;
use App\Helpers\Helper;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\ManagerDashboard\Reports\ManagerReports\AbsentLate;
use Carbon\Carbon;


class StudentAdminstrativeAbsentLateReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $school = School::findOrFail($this->school_id);


        $data =[
            'id'=>$this->id,
            'report_title'=>'تقارير الغياب والتأخر',
            'date'=>$this->date,
            'date_type'=>$this->date_type?$this->date_type:'coptic',
            'report_category_type'=>trans("api.$this->report_category"),
            'report_type'=>trans("api.$this->report_type"),
            'report_created_at'=>$this->created_at->format('d/m/Y'),

            'semester'=>$this->semester?->name,
            'namozeg_serial_number'=>$this->namozegVersion?->serial_number,
        ];


        if($this->report_category == 'late_students'){
            $data['class_name']= (ClassName::find($this->class_name_id))?ClassName::find($this->class_name_id)->name:NULL;
            $data['class_category']= (ClassName::find($this->class_name_id))?ClassName::find($this->class_name_id)->category:NULL;
            $data['class']= (SchoolClass::find($this->class_id))?SchoolClass::find($this->class_id)->class_number:NULL;
            $data['current_school_year']=$school->current_school_year;
            $data['late_students']=$this->transformStudentLateData($this->id,$school->id);

            if($this->report_type == 'weekly'){
                $semester= Helper::getCurrentSchoolSemester();
                $startWeekDay =SemesterWeekDay::where('semester_id',$semester->id)->where('week_id',$this->week_id)->orderBy('id', 'asc')->first();
                $endWeekDay =SemesterWeekDay::where('semester_id',$semester->id)->where('week_id',$this->week_id)->orderBy('id', 'desc')->first();

                $data['week']= $this->week?->name;
                $data['start_week_day']= $startWeekDay->date;
                $data['end_week_day']= $endWeekDay->date;
            }

            if($this->report_type == 'daily'){
                $date = Carbon::createFromFormat('d/m/Y', $this->date);
                $day = $date->translatedFormat('l');
                $data['day']= $day;
            }

        }

        if($this->report_category == 'absent_students'){
            $data['class_name']= (ClassName::find($this->class_name_id))?ClassName::find($this->class_name_id)->name:NULL;
            $data['class_category']= (ClassName::find($this->class_name_id))?ClassName::find($this->class_name_id)->category:NULL;
            $data['class']= (SchoolClass::find($this->class_id))?SchoolClass::find($this->class_id)->class_number:NULL;
            $data['current_school_year']=$school->current_school_year;
            $data['absent_students']=$this->transformStudentAbsentData($this->id,$school->id);
            if($this->report_type == 'weekly'){
                $semester= Helper::getCurrentSchoolSemester();
                $startWeekDay =SemesterWeekDay::where('semester_id',$semester->id)->where('week_id',$this->week_id)->orderBy('id', 'asc')->first();
                $endWeekDay =SemesterWeekDay::where('semester_id',$semester->id)->where('week_id',$this->week_id)->orderBy('id', 'desc')->first();

                $data['week']= $this->week?->name;
                $data['start_week_day']= $startWeekDay->date;
                $data['end_week_day']= $endWeekDay->date;
            }

            if($this->report_type == 'daily'){
                $date = Carbon::createFromFormat('d/m/Y', $this->date);
                $day = $date->translatedFormat('l');
                $data['day']= $day;
            }

        }

        return $data;
    }

    public function totalLateMinutes($schoolId){
        $teacherAttendances = SchoolEmployeeAttendance::where('school_id', $schoolId)
            ->where('status', 'late')
            ->get();
        $totalLateMinutes = 0;
        foreach ($teacherAttendances as $attendance) {
            $lateFrom = DateTime::createFromFormat('h:ia', $attendance->late_from_time);
            $lateTo = DateTime::createFromFormat('h:ia', $attendance->late_to_time);
            if ($lateFrom && $lateTo) {
                $difference = $lateFrom->diff($lateTo);
                $totalLateMinutes += ($difference->h * 60) + $difference->i;
            }
        }
        return $totalLateMinutes;
    }


    private function transformStudentLateData($report_id,$school_id){

        $students = Student::where('school_id',$school_id)->get();
        if (is_null($students)) {
            return [];
        }

        $report = AbsentLate::find($report_id);

        return $students->map(function ($student) use ($report){
            $data=[
                'id'=>$student->id,
                'employee_name'=>$student->name,
                'ssn'=>$student->ssn,
            ];

            if($report->report_type == 'classy'){
                $lateWithExcuse = StudentLateness::where('student_id',$student->id)->where('class_id',$report->class_id)->where('status','late_with_excuse')->exists();
                $lateWithOutExcuse = StudentLateness::where('student_id',$student->id)->where('class_id',$report->class_id)->where('status','late')->exists();

                $data['late_with_excuse']=$lateWithExcuse?trans('api.yes'):trans('api.no');
                $data['late_without_excuse']=$lateWithOutExcuse?trans('api.yes'):trans('api.no');
            }

            if($report->report_type == 'daily'){
                $lateWithExcuse = StudentLateness::where('student_id',$student->id)->where('date',$report->date)->where('status','late_with_excuse')->exists();
                $lateWithOutExcuse = StudentLateness::where('student_id',$student->id)->where('date',$report->date)->where('status','late')->exists();

                $data['late_with_excuse']=$lateWithExcuse?trans('api.yes'):trans('api.no');
                $data['late_without_excuse']=$lateWithOutExcuse?trans('api.yes'):trans('api.no');

            }

            if($report->report_type == 'weekly'){
                $semester= Helper::getCurrentSchoolSemester();
                $startWeekDay =SemesterWeekDay::where('semester_id',$semester->id)->where('week_id',$report->week_id)->orderBy('id', 'asc')->first();
                $endWeekDay =SemesterWeekDay::where('semester_id',$semester->id)->where('week_id',$report->week_id)->orderBy('id', 'desc')->first();

                $lateWithExcuse = StudentLateness::where('student_id',$student->id)->whereBetween('date',[$startWeekDay->date,$endWeekDay->date])->where('class_id',$report->class_id)->where('status','late_with_excuse')->count();
                $lateWithOutExcuse = StudentLateness::where('student_id',$student->id)->whereBetween('date',[$startWeekDay->date,$endWeekDay->date])->where('class_id',$report->class_id)->where('status','late')->count();

                $data['late_with_excuse']=$lateWithExcuse;
                $data['late_without_excuse']=$lateWithOutExcuse;


                // Parse dates correctly based on format
                $startWeekDayDate = Carbon::createFromFormat('d/m/Y', $startWeekDay->date);
                $endWeekDayDate = Carbon::createFromFormat('d/m/Y', $endWeekDay->date);

                $currentDate = $startWeekDayDate->copy();
                while ($currentDate->lte($endWeekDayDate)) {
                    $dayName = $currentDate->format('l');
                    $date = $currentDate->format('d/m/Y');

                    $late = StudentLateness::where('student_id', $student->id)
                        ->where('date', $date)
                        ->where('class_id', $report->class_id)
                        ->where('status', 'late')
                        ->exists();

                    $late_with_excuse = StudentLateness::where('student_id', $student->id)
                        ->where('date', $date)
                        ->where('class_id', $report->class_id)
                        ->where('status', 'late_with_excuse')
                        ->exists();
                    $dailyLateness[]= [
                        'day' => $dayName,
                        'date' => $date,
                        'late'=>$late? trans('api.late'):'',
                        'late_with_excuse'=>$late_with_excuse? trans('api.late_with_excuse'):'',
                    ];

                    $currentDate->addDay();
                }

                $data['daily_lateness'] = $dailyLateness;


            }

            return $data;
        })->all();
    }


    private function transformStudentAbsentData($report_id,$school_id){

        $students = Student::where('school_id',$school_id)->get();
        if (is_null($students)) {
            return [];
        }

        $report = AbsentLate::find($report_id);

        return $students->map(function ($student) use ($report) {
            $data=[
                'id'=>$student->id,
                'employee_name'=>$student->name,
                'ssn'=>$student->ssn,
            ];

            if($report->report_type == 'classy'){
                $absentWithExcuse = StudentAttendance::where('student_id',$student->id)->where('class_id',$report->class_id)->where('status','absent_with_excuse')->count();
                $absentWithOutExcuse = StudentAttendance::where('student_id',$student->id)->where('class_id',$report->class_id)->where('status','absent')->count();
                $absentWithExcusePeriods = PeriodStudentAttendance::where('student_id',$student->id)->where('class_id',$report->class_id)->where('status','absent_with_excuse')->count();
                $absentWithOutExcusePeriods = PeriodStudentAttendance::where('student_id',$student->id)->where('class_id',$report->class_id)->where('status','absent')->count();

                $data['absent_with_excuse']=$absentWithExcuse;
                $data['absent_without_excuse']=$absentWithOutExcuse;
                $data['absent_with_excuse_periods']=$absentWithExcusePeriods;
                $data['absent_without_excuse_periods']=$absentWithOutExcusePeriods;

            }

            if($report->report_type == 'daily'){
                $absentWithExcuse = StudentAttendance::where('student_id',$student->id)->where('date',$report->date)->where('status','absent_with_excuse')->count();
                $absentWithOutExcuse = StudentAttendance::where('student_id',$student->id)->where('date',$report->date)->where('status','absent')->count();
                $absentWithExcusePeriods = PeriodStudentAttendance::where('student_id',$student->id)->where('date',$report->date)->where('status','absent_with_excuse')->count();
                $absentWithOutExcusePeriods = PeriodStudentAttendance::where('student_id',$student->id)->where('date',$report->date)->where('status','absent')->count();

                $data['absent_with_excuse']=$absentWithExcuse;
                $data['absent_without_excuse']=$absentWithOutExcuse;
                $data['absent_with_excuse_periods']=$absentWithExcusePeriods;
                $data['absent_without_excuse_periods']=$absentWithOutExcusePeriods;

            }

            if($report->report_type == 'weekly'){
                $semester= Helper::getCurrentSchoolSemester();
                $startWeekDay =SemesterWeekDay::where('semester_id',$semester->id)->where('week_id',$report->week_id)->orderBy('id', 'asc')->first();
                $endWeekDay =SemesterWeekDay::where('semester_id',$semester->id)->where('week_id',$report->week_id)->orderBy('id', 'desc')->first();

                $absentWithExcuse = StudentAttendance::where('student_id',$student->id)->whereBetween('date',[$startWeekDay->date,$endWeekDay->date])->where('class_id',$report->class_id)->where('status','absent_with_excuse')->count();
                $absentWithOutExcuse = StudentAttendance::where('student_id',$student->id)->whereBetween('date',[$startWeekDay->date,$endWeekDay->date])->where('class_id',$report->class_id)->where('status','absent')->count();
                $absentWithExcusePeriods = PeriodStudentAttendance::where('student_id',$student->id)->whereBetween('date',[$startWeekDay->date,$endWeekDay->date])->where('class_id',$report->class_id)->where('status','absent_with_excuse')->count();
                $absentWithOutExcusePeriods = PeriodStudentAttendance::where('student_id',$student->id)->whereBetween('date',[$startWeekDay->date,$endWeekDay->date])->where('class_id',$report->class_id)->where('status','absent')->count();

                $data['absent_with_excuse']=$absentWithExcuse;
                $data['absent_without_excuse']=$absentWithOutExcuse;
                $data['absent_with_excuse_periods']=$absentWithExcusePeriods;
                $data['absent_without_excuse_periods']=$absentWithOutExcusePeriods;

                // Parse dates correctly based on format
                $startWeekDayDate = Carbon::createFromFormat('d/m/Y', $startWeekDay->date);
                $endWeekDayDate = Carbon::createFromFormat('d/m/Y', $endWeekDay->date);

                $currentDate = $startWeekDayDate->copy();
                while ($currentDate->lte($endWeekDayDate)) {
                    $dayName = $currentDate->format('l');
                    $date = $currentDate->format('d/m/Y');

                    $absent = StudentAttendance::where('student_id', $student->id)
                        ->where('date', $date)
                        ->where('class_id', $report->class_id)
                        ->where('status', 'absent')
                        ->exists();

                    $absent_with_excuse = StudentAttendance::where('student_id', $student->id)
                        ->where('date', $date)
                        ->where('class_id', $report->class_id)
                        ->where('status', 'absent_with_excuse')
                        ->exists();
                    $dailyAttendance[] = [
                        'day' => $dayName,
                        'date' => $date,
                        'absent'=>$absent? trans('api.absent'):'',
                        'absent_with_excuse'=>$absent_with_excuse? trans('api.absent_with_excuse'):'',
                    ];

                    // Move to the next day
                    $currentDate->addDay();
                }

                $data['daily_attendance']=$dailyAttendance;


            }

            return $data;
        })->all();
    }
}
