<?php

namespace App\Http\Resources\ManagerDashboard\Reports\SchoolAdminstrativeReport;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegAbsenceQuestioning;
use App\Models\ManagerDashboard\Namazeg\NamazegNotifyLateLeaving;
use App\Models\ManagerDashboard\Namazeg\NamazegQuestioning;
use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use App\Models\ManagerDashboard\SupervisionSchedul;
use App\Models\ManagerDashboard\Tables\WaitingPeriodsSchedule\WaitingPeriodsSchedule;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class  SchoolAdminstrativeWorkReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $school = School::findOrFail($this->school_id);
        $schoolEmployee = SchoolEmployee::where('school_id', $school->id)
            ->where('current_work_id', 7)
            ->first();


        $accountabilities = 0;  // Set it once since it's always 0
        // Initialize variables to avoid "undefined variable" issues
        $verbalAlerts = $writtenAlerts = $supervisionScheduls = $waitingPeriodsSchedules = 0;

        // Determine report type
        switch ($this->report_type) {
            case 'daily':
                $verbalAlerts = $this->getAlertsCount($school->id, $schoolEmployee->user_id, 'verbal', $this->date);
                $writtenAlerts = $this->getAlertsCount($school->id, $schoolEmployee->user_id, 'written', $this->date);
                $supervisionScheduls = $this->getScheduleCount($school->id, $schoolEmployee->user_id, 'daily', $this->date);
                $waitingPeriodsSchedules = $this->getWaitingPeriodsCount($school->id, $schoolEmployee->user_id, 'daily', $this->date);

                $accountabilities = $this->getAccountabilitiesCount($school->user_id, $schoolEmployee->id, [$this->date , $this->date]);

                break;

            case 'period':
                $startDate = Carbon::createFromFormat('d/m/Y', $this->date_from)->format('Y-m-d');
                $endDate = Carbon::createFromFormat('d/m/Y', $this->date_to)->format('Y-m-d');

                $verbalAlerts = $this->getAlertsCount($school->id, $schoolEmployee->user_id, 'verbal', null, [$startDate, $endDate]);
                $writtenAlerts = $this->getAlertsCount($school->id, $schoolEmployee->user_id, 'written', null, [$startDate, $endDate]);
                $supervisionScheduls = $this->getScheduleCount($school->id, $schoolEmployee->user_id, 'period', null, [$startDate, $endDate]);
                $waitingPeriodsSchedules = $this->getWaitingPeriodsCount($school->id, $schoolEmployee->user_id, 'period', null, [$startDate, $endDate]);

                $accountabilities = $this->getAccountabilitiesCount($school->id, $schoolEmployee->user_id, [$startDate, $endDate]);

                break;

            case 'monthly':
                $verbalAlerts = $this->getAlertsCount($school->id, $schoolEmployee->user_id, 'verbal', null, null, $this->month);
                $writtenAlerts = $this->getAlertsCount($school->id, $schoolEmployee->user_id, 'written', null, null, $this->month);
                $supervisionScheduls = $this->getScheduleCount($school->id, $schoolEmployee->user_id, 'monthly', null, null, $this->month);
                $waitingPeriodsSchedules = $this->getWaitingPeriodsCount($school->id, $schoolEmployee->user_id, 'monthly', null, null, $this->month);

                // Get the first day of the specified month
                $startDate = Carbon::createFromDate(date('Y'), $this->month, 1)->startOfMonth()->format('Y-m-d');
                $endDate = Carbon::createFromDate(date('Y'), $this->month, 1)->endOfMonth()->format('Y-m-d');
                $accountabilities = $this->getAccountabilitiesCount($school->user_id, $schoolEmployee->id, [$startDate, $endDate]);

                break;
        }
        $month =date("F", mktime(0, 0, 0, $this->month, 1));
        return [
            'id' => $this->id,
            'report_title'=>'تقارير أعمالي',
            'report_type' => trans("api.$this->report_type"),
            'date' => $this->date,
            'date_type' => $this->date_type,
            'verbalAlerts' => $verbalAlerts,
            'writtenAlerts' => $writtenAlerts,
            'accountabilities' => $accountabilities,
            'supervisionScheduls' => $supervisionScheduls,
            'waitingPeriodsSchedules' => $waitingPeriodsSchedules,
            'date_from'=>$this->date_from,
            'date_from_type'=>$this->date_from_type,
            'date_to'=>$this->date_to,
            'date_to_type'=>$this->date_to_type,
            'month'=> $this->month? trans("api.$month") : NULL,

            'report_created_at'=>$this->created_at->format('d/m/Y'),
        ];
    }

    /**
     * Get alerts count based on different criteria.
     */
    private function getAlertsCount($schoolId, $employeeId, $type, $date = null, $dateRange = null, $month = null)
    {
        $query = Alert::where('school_id', $schoolId)
            ->where('type', $type)
            ->where('user_id', $employeeId);

        if ($date) {
            $query->where('date', $date);
        }

        if ($dateRange) {
            $query->whereBetween('updated_at', $dateRange);
        }

        if ($month) {
            $query->whereMonth('updated_at', $month);
        }

        return $query->count();
    }

    /**
     * Get supervision schedule count.
     */
    private function getScheduleCount($schoolId, $employeeId, $reportType, $date = null, $dateRange = null, $month = null)
    {
        $query = SupervisionSchedul::where('school_id', $schoolId)
            ->where('user_id', $employeeId);

        if ($reportType == 'daily' && $date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d');
            $query->whereDate('updated_at', $formattedDate);
        }

        if ($reportType == 'period' && $dateRange) {
            $query->whereBetween('updated_at', $dateRange);
        }

        if ($reportType == 'monthly' && $month) {
            $query->whereMonth('updated_at', $month);
        }

        return $query->count();
    }

    /**
     * Get waiting periods schedules count.
     */
    private function getWaitingPeriodsCount($schoolId, $employeeId, $reportType, $date = null, $dateRange = null, $month = null)
    {
        $query = WaitingPeriodsSchedule::where('school_id', $schoolId)
            ->where('user_id', $employeeId);

        if ($reportType == 'daily' && $date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d');
            $query->whereDate('updated_at', $formattedDate);
        }

        if ($reportType == 'period' && $dateRange) {
            $query->whereBetween('updated_at', $dateRange);
        }

        if ($reportType == 'monthly' && $month) {
            $query->whereMonth('updated_at', $month);
        }

        return $query->count();
    }

    private function getAccountabilitiesCount($schoolId, $employeeId, $dateRange){

        //مسآله عاديه//
        $query1 = NamazegQuestioning::where('school_id', $schoolId)
            ->where('user_id', $employeeId);

        //مسآله غياب//
        $query2 = NamazegAbsenceQuestioning::where('school_id', $schoolId)
            ->where('user_id', $employeeId);

        //تنبية عن تاخير//
        $query3 = NamazegNotifyLateLeaving::where('school_id', $schoolId)
            ->where('user_id', $employeeId);

        if ($dateRange) {
            $query1->whereBetween('updated_at', $dateRange);
            $query2->whereBetween('updated_at', $dateRange);
            $query3->whereBetween('updated_at', $dateRange);
        }

        return $query1->count() + $query2->count() + $query3->count();
    }


}
