<?php

namespace App\Http\Resources\ManagerDashboard\Reports\ManagerReport;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Team;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TeamCommitteesMeetingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $school = School::findOrFail($this->school_id);
        $teamsMeetings= TeamMeetingResource::collection(Team::where('school_id',null)->orWhere('school_id',$school->id)->get());
        $committeesMeetings= CommitteeMeetingResource::collection(Committee::where('school_id',null)->orWhere('school_id',$school->id)->get());

        return [
            'id'=>$this->id,
            'report_title'=>'تقارير اجتماعات اللجان والفرق',
            'date'=>$this->date,
            'date_type'=>$this->date_type,
            'teams_meetings'=>$teamsMeetings,
            'committees_meetings'=>$committeesMeetings,
            'report_created_at'=>$this->created_at->format('d/m/Y'),
        ];
    }



}
