<?php

namespace App\Http\Resources\ManagerDashboard\Reports\ManagerReport;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolEmployeeAttendance;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAttendance;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SchoolStatusStatisticsReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $school = School::findOrFail($this->school_id);
        $schoolEmployeeIds = SchoolEmployee::where('school_id',$school->id)->where('type','teacher')->pluck('id')->toArray();

        $schoolEmployeesCount= SchoolEmployee::where('school_id',$school->id)->where('type','teacher')->count();
        $attendedSchoolEmployees = SchoolEmployeeAttendance::whereIn('school_employee_id',$schoolEmployeeIds)->where('status','attended')->where('date',$this->date)->count();
        $absentSchoolEmployeesWithExcuse = SchoolEmployeeAttendance::whereIn('school_employee_id',$schoolEmployeeIds)->where('status','absent')->where('absence_reason','!=','without_excuse')->where('date',$this->date)->count();
        $absent_without_excuse_teachers = SchoolEmployeeAttendance::whereIn('school_employee_id',$schoolEmployeeIds)->where('status','absent')->where('absence_reason','without_excuse')->where('date',$this->date)->count();
        $lateSchoolEmployees = SchoolEmployeeAttendance::whereIn('school_employee_id',$schoolEmployeeIds)->where('status','late')->where('date',$this->date)->count();

        $schoolStudentIds = Student::where('school_id',$school->id)->pluck('id')->toArray();
        $schoolStudentsCount= Student::where('school_id',$school->id)->count();
        $attendedSchoolStudents = StudentAttendance::whereIn('student_id',$schoolStudentIds)->where('status','attended')->where('date',$this->date)->count();
        $absentSchoolStudentsWithExcuse = StudentAttendance::whereIn('student_id',$schoolStudentIds)->where('status','absent_with_excuse')->where('date',$this->date)->count();
        $absentSchoolEmployeesWithOutExcuse = StudentAttendance::whereIn('student_id',$schoolStudentIds)->where('status','absent')->where('date',$this->date)->count();
        $lateSchoolStudents = StudentAttendance::whereIn('student_id',$schoolStudentIds)->where('status','late')->where('date',$this->date)->count();


        return [
            'id'=>$this->id,
            'report_title'=>'تقرير إحصائيات حالة المدرسة',
            'date'=>$this->date,
            'date_type'=>$this->date_type,
            'total_teachers'=>$schoolEmployeesCount,
            'attended_teachers'=>$attendedSchoolEmployees,
            'late_teachers'=>$lateSchoolEmployees,
            'absent_with_excuse_teachers'=>$absentSchoolEmployeesWithExcuse,
            'absent_without_excuse_teachers'=>$absent_without_excuse_teachers,
            'teachers_total_late_time'=>$this->schoolEmployeeTotalLateMinutes($school->id),

            'total_students'=>$schoolStudentsCount,
            'attended_students'=>$attendedSchoolStudents,
            'late_students'=>$lateSchoolStudents,
            'absent_with_excuse_students'=>$absentSchoolStudentsWithExcuse,
            'absent_without_excuse_students'=>$absentSchoolEmployeesWithOutExcuse,
            'students_total_late_time'=> 'NA',

            'report_created_at'=>$this->created_at->format('d/m/Y'),
        ];
    }

    public function schoolEmployeeTotalLateMinutes($schoolId){
        $teacherAttendances = SchoolEmployeeAttendance::where('school_id', $schoolId)
            ->where('status', 'late')
            ->get();
        $totalLateMinutes = 0;
        foreach ($teacherAttendances as $attendance) {
            $lateFrom = DateTime::createFromFormat('h:ia', $attendance->late_from_time);
            $lateTo = DateTime::createFromFormat('h:ia', $attendance->late_to_time);
            if ($lateFrom && $lateTo) {
                $difference = $lateFrom->diff($lateTo);
                $totalLateMinutes += ($difference->h * 60) + $difference->i;
            }
        }
        return $totalLateMinutes;
    }

    public function schoolStudentsTotalLateMinutes($schoolId){
        $teacherAttendances = SchoolEmployeeAttendance::where('school_id', $schoolId)
            ->where('status', 'late')
            ->get();
        $totalLateMinutes = 0;
        foreach ($teacherAttendances as $attendance) {
            $lateFrom = DateTime::createFromFormat('h:ia', $attendance->late_from_time);
            $lateTo = DateTime::createFromFormat('h:ia', $attendance->late_to_time);
            if ($lateFrom && $lateTo) {
                $difference = $lateFrom->diff($lateTo);
                $totalLateMinutes += ($difference->h * 60) + $difference->i;
            }
        }
        return $totalLateMinutes;
    }
}
