<?php

namespace App\Http\Resources\ManagerDashboard\Reports\ManagerReport;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Meeting;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CommitteeMeetingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $emergency_meetings = Meeting::where('model_type','committees')->where('model_id',$this->id)->where('meeting_type','urgent')->count();
        $scheduled_meetings =  Meeting::where('model_type','committees')->where('model_id',$this->id)->where('meeting_type','periodic')->count();
        $executed_meetings = Meeting::where('model_type','committees')->where('model_id',$this->id)->where('meeting_status','completed')->count();
        $not_completed_meetings = Meeting::where('model_type','committees')->where('model_id',$this->id)->where('meeting_status','not_completed')->count();
        $drafted_meetings = Meeting::where('model_type','committees')->where('model_id',$this->id)->where('meeting_status','drafted')->count();

        return [
            'committee_name'=>$this->name,
            'committee_responsible_user'=>($this->members()->first())?$this->members()->first()?->employee?->currentWork->job_title:'',
            'emergency_meetings'=>$emergency_meetings,
            'scheduled_meetings'=>$scheduled_meetings,
            'executed_meetings'=>$executed_meetings,
            'not_completed_meetings'=>$not_completed_meetings,
            'drafted_meetings'=>$drafted_meetings,
        ];
    }

}
