<?php

namespace App\Http\Resources\ManagerDashboard\Reports\EducationalAdmisnstrative;

use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassRoomvisitResource;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassRoomVisitSession;
use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use App\Models\ManagerDashboard\SupervisionSchedul;
use App\Models\ManagerDashboard\Tables\WaitingPeriodsSchedule\WaitingPeriodsSchedule;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;


class  EducationalAdminstrativeClassVisitReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $school = School::findOrFail($this->school_id);
        $completedClassRoomVisit = ClassRoomVisitSession::where('school_id',$school->id)->where('semester_id',$this->semester_id)->where('visit_status','complete')->count();
        $incompletedClassRoomVisit = ClassRoomVisitSession::where('school_id',$school->id)->where('semester_id',$this->semester_id)->where('visit_status','incomplete')->count();
        $classRoomvisits = ClassRoomvisitResource::collection(ClassRoomVisitSession::where('school_id',$school->id)->where('semester_id',$this->semester_id)->get());
        return [
            'id' => $this->id,
            'report_title'=>'تقارير الزيارات الصفية',
            'semester'=>$this->semester?->name,
            'date_type'=>'coptic',
            'report_created_at'=>$this->created_at->format('d/m/Y'),
            'completed_classRoom_visits'=>$completedClassRoomVisit,
            'incompleted_classRoom_visits'=>$incompletedClassRoomVisit,
            'classRoom_visits'=>$classRoomvisits,

        ];
    }

}
