<?php

namespace App\Http\Resources\ManagerDashboard\Reports\EducationalAdmisnstrative;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\ManagerDashboard\Namazeg\NamazegAbsenceQuestioning;
use App\Models\ManagerDashboard\Namazeg\NamazegNotifyLateLeaving;
use App\Models\ManagerDashboard\Namazeg\NamazegQuestioning;
use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;


class  EducationalAdminstrativeAlertReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $school = School::findOrFail($this->school_id);

        $schoolEmployee = SchoolEmployee::where('school_id', $school->id)
            ->where('current_work_id', 6)
            ->first();

        $startWeekDay =SemesterWeekDay::where('semester_id',$this->semester_id)->orderBy('id', 'asc')->first();
        $endWeekDay =SemesterWeekDay::where('semester_id',$this->semester_id)->orderBy('id', 'desc')->first();

        $startDate = Carbon::createFromFormat('d/m/Y', $startWeekDay->date)->format('Y-m-d');
        $endDate = Carbon::createFromFormat('d/m/Y', $endWeekDay->date)->format('Y-m-d');

        $verbalAlerts = ($startWeekDay && $endWeekDay) ?
            Alert::where('school_id', $this->school_id)
                ->where('user_id', $schoolEmployee->user_id)
                ->whereRaw("STR_TO_DATE(date, '%d/%m/%Y') BETWEEN ? AND ?", [$startDate, $endDate])
                ->where('type', 'verbal')
                ->count() : 0;

        $writtenAlerts = ($startWeekDay && $endWeekDay) ?
            Alert::where('school_id', $this->school_id)
                ->where('user_id', $schoolEmployee->user_id)
                ->whereRaw("STR_TO_DATE(date, '%d/%m/%Y') BETWEEN ? AND ?", [$startDate, $endDate])
                ->where('type', 'written')
                ->count() : 0;


        $accountabilities = ($startWeekDay &&$endWeekDay)?$this->getAccountabilitiesCount($school->id, $schoolEmployee->user_id, [$startDate , $endDate]):0;

        return [
            'id' => $this->id,
            'report_title'=>'تقارير المساءلات والتنبيهات',
            'semester'=>$this->semester?->name,
            'report_created_at'=>$this->created_at->format('d/m/Y'),
            'date_type'=>'coptic',
            'verbal_alerts'=>$verbalAlerts,
            'written_alerts'=>$writtenAlerts,
            'accountabilities'=>$accountabilities,
            'teachers_alerts'=>$this->transformTeachersAlertsData($school->id),


        ];
    }


    private function transformTeachersAlertsData($school_id){
        $employees = SchoolEmployee::where('school_id',$school_id)->where('type','teacher')->get();
        if (is_null($employees)) {
            return [];
        }

        $startWeekDay =SemesterWeekDay::where('semester_id',$this->semester_id)->orderBy('id', 'asc')->first();
        $endWeekDay =SemesterWeekDay::where('semester_id',$this->semester_id)->orderBy('id', 'desc')->first();
        $startDate = Carbon::createFromFormat('d/m/Y', $startWeekDay->date)->format('Y-m-d');
        $endDate = Carbon::createFromFormat('d/m/Y', $endWeekDay->date)->format('Y-m-d');

        return $employees->map(function ($employee) use ($startWeekDay , $endWeekDay ,$startDate ,$endDate) {
            $verbalAlerts = ($startWeekDay && $endWeekDay) ?
                Alert::where('school_id', $this->school_id)
                    ->where('alert_direct_to',$employee->id)
                    ->whereRaw("STR_TO_DATE(date, '%d/%m/%Y') BETWEEN ? AND ?", [$startDate, $endDate])
                    ->where('type', 'verbal')
                    ->count() : 0;

            $writtenAlerts = ($startWeekDay && $endWeekDay) ?
                Alert::where('school_id', $this->school_id)
                    ->where('alert_direct_to',$employee->id)
                    ->whereRaw("STR_TO_DATE(date, '%d/%m/%Y') BETWEEN ? AND ?", [$startDate, $endDate])
                    ->where('type', 'written')
                    ->count() : 0;

            $accountabilities = $this->getEmployeeAccountabilitiesCount($this->school_id, $employee->id,[$startDate , $endDate]);

            $data=[
                'id'=>$employee->id,
                'employee_name'=>$employee->name,
                'ssn'=>$employee->ssn,
                'verbal_alerts'=>$verbalAlerts,
                'written_alerts'=>$writtenAlerts,
                'accountabilities' => $accountabilities,
            ];

            return $data;
        })->all();
    }

    private function getAccountabilitiesCount($schoolId, $employeeId, $dateRange){

        //مسآله عاديه//
        $query1 = NamazegQuestioning::where('school_id', $schoolId)
            ->where('user_id', $employeeId);

        //مسآله غياب//
        $query2 = NamazegAbsenceQuestioning::where('school_id', $schoolId)
            ->where('user_id', $employeeId);

        //تنبية عن تاخير//
        $query3 = NamazegNotifyLateLeaving::where('school_id', $schoolId)
            ->where('user_id', $employeeId);

        if ($dateRange) {
            $query1->whereBetween('updated_at', $dateRange);
            $query2->whereBetween('updated_at', $dateRange);
            $query3->whereBetween('updated_at', $dateRange);
        }
        return $query1->count() + $query2->count() + $query3->count();
    }

    private function getEmployeeAccountabilitiesCount($schoolId, $employeeId, $dateRange){
        //مسآله عاديه//
        $query1 = NamazegQuestioning::where('school_id', $schoolId)
            ->where('employee_id', $employeeId);

        //مسآله غياب//
        $query2 = NamazegAbsenceQuestioning::where('school_id', $schoolId)
            ->where('employee_id', $employeeId);

        //تنبية عن تاخير//
        $query3 = NamazegNotifyLateLeaving::where('school_id', $schoolId)
            ->where('employee_id', $employeeId);

        if ($dateRange) {
            $query1->whereBetween('updated_at', $dateRange);
            $query2->whereBetween('updated_at', $dateRange);
            $query3->whereBetween('updated_at', $dateRange);
        }
        return $query1->count() + $query2->count() + $query3->count();
    }

}
