<?php

namespace App\Http\Resources\ManagerDashboard\Proceed;

use App\Helpers\Helper;
use App\Http\Resources\School\SchoolEmployeeResource;
use App\Models\AdminDashboard\School\SchoolEmployee;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class ProceedResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $manager_name = SchoolEmployee::where('school_id', $this->school_id)->where('current_work_id', 1)->first()?->name;

        return [
            'id'=>$this->id,
            'title'=>$this->title,
            'text'=>$this->text,
            'manager_name'=> $manager_name,
            'form_number' => $this->namozegVersion->namozeg->form_number,
            'serial_number' => $this->namozegVersion->serial_number,
            'type'=>$this->proceed_type,
            'date_type' => __('api.' . $this->date_type),
            'date' => Carbon::createFromFormat('d/m/Y', $this->date)->format('d/m/Y'),
            'date_options' => Helper::getDateOptions($this->date, $this->type),
            'employees' => $this?->proceedUsers->map(function ($user) {
                return new SchoolEmployeeResource($user->employee);
            }),
        
        ];
    }
}
