<?php

namespace App\Http\Resources\ManagerDashboard\Namazeg;

use App\Helpers\Helper;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class ReportPlanActivityResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => 'التقرير الختامى لحصص الاتقان رقم ' . $this->id,
            'serial_number' => $this->namozegVersion->serial_number,
            'employees' => $this->employees->pluck('name'),
            'n_medical_sessions' => $this->n_medical_sessions,
            'percent_medical_sessions' => $this->percent_medical_sessions . '%',
            'n_ernrichment_sessions' => $this->n_ernrichment_sessions,
            'percent_ernrichment_sessions' => $this->percent_ernrichment_sessions . '%',
            'difficulty' => $this->difficulty,
            'challenges' => $this->challenges,
            'solutions' => $this->solutions,
            'suggestions' => $this->suggestions,
            'date' => $this->date ? Carbon::createFromFormat('d/m/Y', $this->date)->translatedFormat('d F Y', 'ar') : null,
            'created_at' =>  $this->created_at->translatedFormat('d F Y', 'ar'),
        ];
    }
}
