<?php

namespace App\Http\Resources\ManagerDashboard\Namazeg;

use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class PlanActivityResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => "الخطة العامة لأنشطة حصص الاتقان رقم ". $this->id,
            'n_classes' => $this->n_classes,
            'serial_number' => $this->namozegVersion->serial_number,
            'employees' => $this->employees->pluck('name'),
            'specializations' => $this->specializations->pluck('title'),
            'created_at' =>  $this->created_at->translatedFormat('d F Y', 'ar'),
        ];
    }
}
