<?php

namespace App\Http\Resources\ManagerDashboard\Namazeg;

use App\Helpers\Helper;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class CircularAttendanceReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'serial_number' => $this->namozegVersion->serial_number,
            'issued_by' => $this->issued_by,
            'code' => $this->code,
            'date' =>  Helper::getDateOptions( $this->date, 'coptic'), 
            'created_at' =>  $this->created_at->translatedFormat('d F Y', 'ar')
        ];
    }
}
