<?php

namespace App\Http\Resources\ManagerDashboard\Messages;

use App\Helpers\Helper;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class MessageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $date = Carbon::parse($this->updated_at)->format('d/m/Y');
        $user_type = $this->receptors->first()->user_type;
        return [
            'id' => $this->id,
            'message' => $this->message,
            'type' =>  __('api.'. $this->type),
            'user_type' => $user_type,
            'school_class_id' => $user_type=="student"? $this->receptors->first()?->users?->schoolClass->id:'0',
            'date' => $this->updated_at->format('d/m/Y'),
            'date_options' => Helper::getDateOptions($date, 'coptic'),
            'users' => $this->receptors->map(function ($receptor) {
                return [
                    'user_id' => $receptor->user_id,
                    'name' => $receptor->users?->name
                ];
            }),
        ];
    }

}
