<?php

namespace App\Http\Resources\ManagerDashboard\Messages;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class MessageHistoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'name' => $this->user?->name,
            'message' => $this->message->message,
            'date' => $this->updated_at->format('Y/m/d'),
            'school_id' => $this->message->school_id,


        ];
    }
}
