<?php

namespace App\Http\Resources\ManagerDashboard\Exams\SupervisionCommittees;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CommitteeResource extends JsonResource
{
    protected $currentWork;
    protected $assignmentWorks;
    protected $includeCurrentWork;

    public function __construct($resource, $currentWork = null, $assignmentWorks = [], $includeCurrentWork = false)
    {
        parent::__construct($resource);
        $this->currentWork = $currentWork;
        $this->assignmentWorks = $assignmentWorks;
        $this->includeCurrentWork = $includeCurrentWork;
    }

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        $response = [
            'id' => $this->id,
            'name' => $this->name,
            'assignment_form_number' => $this->assignment_form_number,

        ];

        // Include assignmentWorks only in the show context
        if ($this->assignmentWorks && $this->includeCurrentWork) {
            $response['assignmentWorks'] = $this->assignmentWorks;
        }

        // Include current work only if the flag is set
        if ($this->includeCurrentWork && $this->currentWork) {
            $response['Assignment_current_works'] = $this->currentWork->map(function ($work) {
                return [
                    'id' => $work->id,
                    'job_title' => $work->job_title,
                    'employees' => $work->employees->map(function ($employee) {
                        return [
                            'id' => $employee->id,
                            'name' => $employee->name,
                        ];
                    }),
                ];
            });
        }

        return $response;
    }
}
