<?php

namespace App\Http\Resources\ManagerDashboard\Exams\NamazegPlans;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TeacherCurriculumDeclarationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'serial_number' => $this->namozegVersion?->serial_number,
            'teacher_id' => $this->teacher_id,
            'teacher' => $this->employee?->name,
            'created_at' =>  $this->created_at->translatedFormat('d F Y', 'ar'),
        ];
    }
}
