<?php

namespace App\Http\Resources\ManagerDashboard\Exams\NamazegPlans;

use App\Models\AdminDashboard\School\SchoolEmployee;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MonitorDailyObserversResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        Carbon::setLocale('ar');

        // Parse the date and get the day in Arabic
        $day = Carbon::createFromFormat('d/m/Y', $this->date)->locale('ar')->translatedFormat('l');
        
        return [
            'id' => $this->id,
            'employee_id' => $this->employee_id,
            'name' => $this->employee->name,
            'day' =>   $day,
            'date' => $this->date,
            'period' => json_decode($this->period),
            'status' => $this->dailyObserve ? 'complated' : 'incomplated',
            'dailyObserve' => $this->dailyObserve ? [
                'id' => $this->dailyObserve->id,
                'school_id' => $this->dailyObserve->school_id,
                'serial_number' => $this->dailyObserve->namozegVersion?->serial_number,
                'committee_id' => $this->dailyObserve->committee_id,
                'committee_name' => $this->dailyObserve->exam_comittee->name,
                'committee_location' => empty($this->dailyObserve->exam_comittee->CommitteeData)
                    ? $this->dailyObserve->exam_comittee->name
                    : (isset($this->dailyObserve->exam_comittee->CommitteeData[0])
                        ? $this->dailyObserve->exam_comittee->CommitteeData[0]->location
                        : $this->dailyObserve->exam_comittee->name),
                'subject_id' => $this->dailyObserve->subject_id,
                'subject_name' =>  $this->dailyObserve->subject->name,
                'exam_time' =>  $this->dailyObserve->exam_time,
                'employees' => $this->dailyObserve->employees_ids ? collect(json_decode($this->dailyObserve->employees_ids))->map(function ($employeeId) {
                    $employee = SchoolEmployee::find($employeeId);
                    return $employee ? [
                        'id' => $employee->id,
                        'name' => $employee->name,
                    ] : null;
                })->values() : [],
            ] : null,
        ];
    }
}
