<?php

namespace App\Http\Resources\ManagerDashboard\ClassRoomVisit;

use Alkoumi\LaravelHijriDate\Hijri;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;
use IntlDateFormatter;
use App\Helpers\Helper;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassRoomVisitSession;

class ClassRoomvisitResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // Set locale to Arabic
        Carbon::setLocale('ar');

        // Parse the date from the format `d/m/Y`
        $gregorianDate = Carbon::createFromFormat('d/m/Y', $this->date);

        // Initialize date variable
        $formattedDate = '';

        if ($this->date_type === 'coptic') {
            $date = Helper::getDateOptions($this->date, $this->date_type)['coptic'];
            $gregorianDate = Carbon::createFromFormat('d/m/Y', $date);
            $date = $gregorianDate->translatedFormat('l d F Y');
        } else {
            $date = Helper::getDateOptions($this->date, $this->date_type)['hijri'];
            $date = Helper::getCoptic($this->date);

            $gregorianDate = Carbon::createFromFormat('d/m/Y', $date);

            $date =  Hijri::Date('l j F Y', $gregorianDate);
        }

        $teacher_num_visits = ClassRoomVisitSession::where('school_teacher_id',$this->school_teacher_id)->where('school_id',$this->school_id)->count();
        return [
            'id' => $this->id,
            'serial_number' => $this->namozegVersion?->serial_number,
            'rate_serial_number' => $this->rate_namozegVersion?->serial_number,
            'semester_id' => $this->semester?->id,
            'semester' => $this->semester?->name,
            'teacher' => $this->teacher?->name,
            'teacher_specialization' => $this->teacher->specialization?->title,
            'school_class_id' => $this->school_class_id,
            'class_id' => $this->class->className?->id,
            'class' => $this->class->className?->name,
            'classNumber' => $this->class?->class_number,
            'date' => $date,
            'dat_options' => Helper::getDateOptions($this->date, $this->date_type),
            'date_type' => $this->date_type,
            'visitOfficer' => $this->visitOfficer?->name,
            'period_id' => $this->period?->id,
            'visitPeriod' => $this->period?->name,
            'subject_id' => $this->subject?->id,
            'subject' => $this->subject?->name,
            'visitStatus' => $this->visit_status,
            'teacher_num_visits'=>$teacher_num_visits ?? 0
        ];
    }
}
